/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.XmlColor;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with a paragraph format shading element.")
public class Shading
implements ModelIfc {
    @SerializedName(value="BackgroundPatternColor")
    protected XmlColor backgroundPatternColor = null;
    @SerializedName(value="ForegroundPatternColor")
    protected XmlColor foregroundPatternColor = null;
    @SerializedName(value="Texture")
    protected TextureEnum texture = null;

    @ApiModelProperty(value="Gets or sets the color that's applied to the background of the Shading object.")
    public XmlColor getBackgroundPatternColor() {
        return this.backgroundPatternColor;
    }

    public Shading backgroundPatternColor(XmlColor backgroundPatternColor) {
        this.backgroundPatternColor = backgroundPatternColor;
        return this;
    }

    public void setBackgroundPatternColor(XmlColor backgroundPatternColor) {
        this.backgroundPatternColor = backgroundPatternColor;
    }

    @ApiModelProperty(value="Gets or sets the color that's applied to the foreground of the Shading object.")
    public XmlColor getForegroundPatternColor() {
        return this.foregroundPatternColor;
    }

    public Shading foregroundPatternColor(XmlColor foregroundPatternColor) {
        this.foregroundPatternColor = foregroundPatternColor;
        return this;
    }

    public void setForegroundPatternColor(XmlColor foregroundPatternColor) {
        this.foregroundPatternColor = foregroundPatternColor;
    }

    @ApiModelProperty(value="Gets or sets the shading texture.")
    public TextureEnum getTexture() {
        return this.texture;
    }

    public Shading texture(TextureEnum texture) {
        this.texture = texture;
        return this;
    }

    public void setTexture(TextureEnum texture) {
        this.texture = texture;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.backgroundPatternColor != null) {
            this.backgroundPatternColor.validate();
        }
        if (this.foregroundPatternColor != null) {
            this.foregroundPatternColor.validate();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shading shading = (Shading)o;
        return Objects.equals(this.backgroundPatternColor, shading.backgroundPatternColor) && Objects.equals(this.foregroundPatternColor, shading.foregroundPatternColor) && Objects.equals((Object)this.texture, (Object)shading.texture);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.backgroundPatternColor, this.foregroundPatternColor, this.texture});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Shading {\n");
        sb.append("    backgroundPatternColor: ").append(this.toIndentedString(this.getBackgroundPatternColor())).append("\n");
        sb.append("    foregroundPatternColor: ").append(this.toIndentedString(this.getForegroundPatternColor())).append("\n");
        sb.append("    texture: ").append(this.toIndentedString((Object)this.getTexture())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TextureEnum {
        TEXTURENONE("TextureNone"),
        TEXTURESOLID("TextureSolid"),
        TEXTURE5PERCENT("Texture5Percent"),
        TEXTURE10PERCENT("Texture10Percent"),
        TEXTURE20PERCENT("Texture20Percent"),
        TEXTURE25PERCENT("Texture25Percent"),
        TEXTURE30PERCENT("Texture30Percent"),
        TEXTURE40PERCENT("Texture40Percent"),
        TEXTURE50PERCENT("Texture50Percent"),
        TEXTURE60PERCENT("Texture60Percent"),
        TEXTURE70PERCENT("Texture70Percent"),
        TEXTURE75PERCENT("Texture75Percent"),
        TEXTURE80PERCENT("Texture80Percent"),
        TEXTURE90PERCENT("Texture90Percent"),
        TEXTUREDARKHORIZONTAL("TextureDarkHorizontal"),
        TEXTUREDARKVERTICAL("TextureDarkVertical"),
        TEXTUREDARKDIAGONALDOWN("TextureDarkDiagonalDown"),
        TEXTUREDARKDIAGONALUP("TextureDarkDiagonalUp"),
        TEXTUREDARKCROSS("TextureDarkCross"),
        TEXTUREDARKDIAGONALCROSS("TextureDarkDiagonalCross"),
        TEXTUREHORIZONTAL("TextureHorizontal"),
        TEXTUREVERTICAL("TextureVertical"),
        TEXTUREDIAGONALDOWN("TextureDiagonalDown"),
        TEXTUREDIAGONALUP("TextureDiagonalUp"),
        TEXTURECROSS("TextureCross"),
        TEXTUREDIAGONALCROSS("TextureDiagonalCross"),
        TEXTURE2PT5PERCENT("Texture2Pt5Percent"),
        TEXTURE7PT5PERCENT("Texture7Pt5Percent"),
        TEXTURE12PT5PERCENT("Texture12Pt5Percent"),
        TEXTURE15PERCENT("Texture15Percent"),
        TEXTURE17PT5PERCENT("Texture17Pt5Percent"),
        TEXTURE22PT5PERCENT("Texture22Pt5Percent"),
        TEXTURE27PT5PERCENT("Texture27Pt5Percent"),
        TEXTURE32PT5PERCENT("Texture32Pt5Percent"),
        TEXTURE35PERCENT("Texture35Percent"),
        TEXTURE37PT5PERCENT("Texture37Pt5Percent"),
        TEXTURE42PT5PERCENT("Texture42Pt5Percent"),
        TEXTURE45PERCENT("Texture45Percent"),
        TEXTURE47PT5PERCENT("Texture47Pt5Percent"),
        TEXTURE52PT5PERCENT("Texture52Pt5Percent"),
        TEXTURE55PERCENT("Texture55Percent"),
        TEXTURE57PT5PERCENT("Texture57Pt5Percent"),
        TEXTURE62PT5PERCENT("Texture62Pt5Percent"),
        TEXTURE65PERCENT("Texture65Percent"),
        TEXTURE67PT5PERCENT("Texture67Pt5Percent"),
        TEXTURE72PT5PERCENT("Texture72Pt5Percent"),
        TEXTURE77PT5PERCENT("Texture77Pt5Percent"),
        TEXTURE82PT5PERCENT("Texture82Pt5Percent"),
        TEXTURE85PERCENT("Texture85Percent"),
        TEXTURE87PT5PERCENT("Texture87Pt5Percent"),
        TEXTURE92PT5PERCENT("Texture92Pt5Percent"),
        TEXTURE95PERCENT("Texture95Percent"),
        TEXTURE97PT5PERCENT("Texture97Pt5Percent"),
        TEXTURENIL("TextureNil");

        private String value;

        private TextureEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TextureEnum fromValue(String text) {
            for (TextureEnum b : TextureEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TextureEnum> {
            public void write(JsonWriter jsonWriter, TextureEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TextureEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TextureEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

