/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.Style;
import com.aspose.words.cloud.model.WordsResponse;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The REST response with an array of styles. This response is returned by the Service when handling \"GET https://api.aspose.cloud/v4.0/words/Test.doc/styles\" REST API requests.")
public class StylesResponse
extends WordsResponse {
    @SerializedName(value="Styles")
    protected List<Style> styles = null;

    @ApiModelProperty(value="Gets or sets the array of styles.")
    public List<Style> getStyles() {
        return this.styles;
    }

    public StylesResponse styles(List<Style> styles) {
        this.styles = styles;
        return this;
    }

    public StylesResponse addStylesItem(Style stylesItem) {
        if (this.styles == null) {
            this.styles = new ArrayList<Style>();
        }
        this.styles.add(stylesItem);
        return this;
    }

    public void setStyles(List<Style> styles) {
        this.styles = styles;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.styles != null) {
            for (ModelIfc modelIfc : this.styles) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StylesResponse stylesResponse = (StylesResponse)o;
        return Objects.equals(this.styles, stylesResponse.styles) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.styles, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StylesResponse {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.getRequestId())).append("\n");
        sb.append("    styles: ").append(this.toIndentedString(this.getStyles())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

