/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Base class for paragraph format tab stop DTO.")
public abstract class TabStopBase
implements ModelIfc {
    @SerializedName(value="Alignment")
    protected AlignmentEnum alignment = null;
    @SerializedName(value="Leader")
    protected LeaderEnum leader = null;
    @SerializedName(value="Position")
    protected Double position = null;

    @ApiModelProperty(value="Gets or sets the alignment of text at this tab stop.")
    public AlignmentEnum getAlignment() {
        return this.alignment;
    }

    public TabStopBase alignment(AlignmentEnum alignment) {
        this.alignment = alignment;
        return this;
    }

    public void setAlignment(AlignmentEnum alignment) {
        this.alignment = alignment;
    }

    @ApiModelProperty(value="Gets or sets the type of the leader line displayed under the tab character.")
    public LeaderEnum getLeader() {
        return this.leader;
    }

    public TabStopBase leader(LeaderEnum leader) {
        this.leader = leader;
        return this;
    }

    public void setLeader(LeaderEnum leader) {
        this.leader = leader;
    }

    @ApiModelProperty(value="Gets or sets the position of the tab stop in points.")
    public Double getPosition() {
        return this.position;
    }

    public TabStopBase position(Double position) {
        this.position = position;
        return this;
    }

    public void setPosition(Double position) {
        this.position = position;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.alignment == null) {
            throw new ApiException(400, "Property Alignment in TabStopBase is required.");
        }
        if (this.leader == null) {
            throw new ApiException(400, "Property Leader in TabStopBase is required.");
        }
        if (this.position == null) {
            throw new ApiException(400, "Property Position in TabStopBase is required.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TabStopBase tabStopBase = (TabStopBase)o;
        return Objects.equals((Object)this.alignment, (Object)tabStopBase.alignment) && Objects.equals((Object)this.leader, (Object)tabStopBase.leader) && Objects.equals(this.position, tabStopBase.position);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alignment, this.leader, this.position});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TabStopBase {\n");
        sb.append("    alignment: ").append(this.toIndentedString((Object)this.getAlignment())).append("\n");
        sb.append("    leader: ").append(this.toIndentedString((Object)this.getLeader())).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.getPosition())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AlignmentEnum {
        LEFT("Left"),
        CENTER("Center"),
        RIGHT("Right"),
        DECIMAL("Decimal"),
        BAR("Bar"),
        LIST("List"),
        CLEAR("Clear");

        private String value;

        private AlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AlignmentEnum fromValue(String text) {
            for (AlignmentEnum b : AlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AlignmentEnum> {
            public void write(JsonWriter jsonWriter, AlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LeaderEnum {
        NONE("None"),
        DOTS("Dots"),
        DASHES("Dashes"),
        LINE("Line"),
        HEAVY("Heavy"),
        MIDDLEDOT("MiddleDot");

        private String value;

        private LeaderEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LeaderEnum fromValue(String text) {
            for (LeaderEnum b : LeaderEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LeaderEnum> {
            public void write(JsonWriter jsonWriter, LeaderEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LeaderEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LeaderEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

