/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.TabStop;
import com.aspose.words.cloud.model.WordsResponse;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The REST response with an array of tab stops. This response is returned by the Service when handling \"GET https://api.aspose.cloud/v4.0/words/Test.doc/paragraphs/{0}/tabstops\" REST API requests.")
public class TabStopsResponse
extends WordsResponse {
    @SerializedName(value="TabStops")
    protected List<TabStop> tabStops = null;

    @ApiModelProperty(value="Gets or sets the array of tab stops.")
    public List<TabStop> getTabStops() {
        return this.tabStops;
    }

    public TabStopsResponse tabStops(List<TabStop> tabStops) {
        this.tabStops = tabStops;
        return this;
    }

    public TabStopsResponse addTabStopsItem(TabStop tabStopsItem) {
        if (this.tabStops == null) {
            this.tabStops = new ArrayList<TabStop>();
        }
        this.tabStops.add(tabStopsItem);
        return this;
    }

    public void setTabStops(List<TabStop> tabStops) {
        this.tabStops = tabStops;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.tabStops != null) {
            for (ModelIfc modelIfc : this.tabStops) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TabStopsResponse tabStopsResponse = (TabStopsResponse)o;
        return Objects.equals(this.tabStops, tabStopsResponse.tabStops) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tabStops, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TabStopsResponse {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.getRequestId())).append("\n");
        sb.append("    tabStops: ").append(this.toIndentedString(this.getTabStops())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

