/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.NodeLink;
import com.aspose.words.cloud.model.TableProperties;
import com.aspose.words.cloud.model.TableRow;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with a table element.")
public class Table
extends NodeLink {
    @SerializedName(value="TableRowList")
    protected List<TableRow> tableRowList = null;
    @SerializedName(value="TableProperties")
    protected TableProperties tableProperties = null;

    @ApiModelProperty(value="Gets or sets the collection of table's rows.")
    public List<TableRow> getTableRowList() {
        return this.tableRowList;
    }

    public Table tableRowList(List<TableRow> tableRowList) {
        this.tableRowList = tableRowList;
        return this;
    }

    public Table addTableRowListItem(TableRow tableRowListItem) {
        if (this.tableRowList == null) {
            this.tableRowList = new ArrayList<TableRow>();
        }
        this.tableRowList.add(tableRowListItem);
        return this;
    }

    public void setTableRowList(List<TableRow> tableRowList) {
        this.tableRowList = tableRowList;
    }

    @ApiModelProperty(value="Gets or sets table properties.")
    public TableProperties getTableProperties() {
        return this.tableProperties;
    }

    public Table tableProperties(TableProperties tableProperties) {
        this.tableProperties = tableProperties;
        return this;
    }

    public void setTableProperties(TableProperties tableProperties) {
        this.tableProperties = tableProperties;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.tableRowList != null) {
            for (ModelIfc modelIfc : this.tableRowList) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
        if (this.tableProperties != null) {
            this.tableProperties.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return Objects.equals(this.tableRowList, table.tableRowList) && Objects.equals(this.tableProperties, table.tableProperties) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableRowList, this.tableProperties, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Table {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.getNodeId())).append("\n");
        sb.append("    tableRowList: ").append(this.toIndentedString(this.getTableRowList())).append("\n");
        sb.append("    tableProperties: ").append(this.toIndentedString(this.getTableProperties())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

