/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.Position;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with a table row element.")
public class TableRowInsert
implements ModelIfc {
    @SerializedName(value="ColumnsCount")
    protected Integer columnsCount = null;
    @SerializedName(value="ExistingRowPosition")
    protected Position existingRowPosition = null;
    @SerializedName(value="InsertAfter")
    protected Integer insertAfter = null;

    @ApiModelProperty(value="Gets or sets the count of columns. The default value is 1.")
    public Integer getColumnsCount() {
        return this.columnsCount;
    }

    public TableRowInsert columnsCount(Integer columnsCount) {
        this.columnsCount = columnsCount;
        return this;
    }

    public void setColumnsCount(Integer columnsCount) {
        this.columnsCount = columnsCount;
    }

    @ApiModelProperty(value="Gets or sets the position of the table row that will be used to determine the placement of a new row.")
    public Position getExistingRowPosition() {
        return this.existingRowPosition;
    }

    public TableRowInsert existingRowPosition(Position existingRowPosition) {
        this.existingRowPosition = existingRowPosition;
        return this;
    }

    public void setExistingRowPosition(Position existingRowPosition) {
        this.existingRowPosition = existingRowPosition;
    }

    @ApiModelProperty(value="Gets or sets table row will be inserted after row with specified 0-based index.")
    @Deprecated
    public Integer getInsertAfter() {
        return this.insertAfter;
    }

    @Deprecated
    public TableRowInsert insertAfter(Integer insertAfter) {
        this.insertAfter = insertAfter;
        return this;
    }

    @Deprecated
    public void setInsertAfter(Integer insertAfter) {
        this.insertAfter = insertAfter;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.columnsCount == null) {
            throw new ApiException(400, "Property ColumnsCount in TableRowInsert is required.");
        }
        if (this.existingRowPosition != null) {
            this.existingRowPosition.validate();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableRowInsert tableRowInsert = (TableRowInsert)o;
        return Objects.equals(this.columnsCount, tableRowInsert.columnsCount) && Objects.equals(this.existingRowPosition, tableRowInsert.existingRowPosition) && Objects.equals(this.insertAfter, tableRowInsert.insertAfter);
    }

    public int hashCode() {
        return Objects.hash(this.columnsCount, this.existingRowPosition, this.insertAfter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableRowInsert {\n");
        sb.append("    columnsCount: ").append(this.toIndentedString(this.getColumnsCount())).append("\n");
        sb.append("    existingRowPosition: ").append(this.toIndentedString(this.getExistingRowPosition())).append("\n");
        sb.append("    insertAfter: ").append(this.toIndentedString(this.getInsertAfter())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

