/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ImageSaveOptionsData;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for tiff save options.")
public class TiffSaveOptionsData
extends ImageSaveOptionsData {
    @SerializedName(value="ThresholdForFloydSteinbergDithering")
    protected Integer thresholdForFloydSteinbergDithering = null;
    @SerializedName(value="TiffBinarizationMethod")
    protected TiffBinarizationMethodEnum tiffBinarizationMethod = null;
    @SerializedName(value="TiffCompression")
    protected TiffCompressionEnum tiffCompression = null;

    @ApiModelProperty(value="Gets or sets the threshold that determines the value of the binarization error in the Floyd-Steinberg method. when ImageBinarizationMethod is ImageBinarizationMethod.FloydSteinbergDithering. The default value is 128.")
    public Integer getThresholdForFloydSteinbergDithering() {
        return this.thresholdForFloydSteinbergDithering;
    }

    public TiffSaveOptionsData thresholdForFloydSteinbergDithering(Integer thresholdForFloydSteinbergDithering) {
        this.thresholdForFloydSteinbergDithering = thresholdForFloydSteinbergDithering;
        return this;
    }

    public void setThresholdForFloydSteinbergDithering(Integer thresholdForFloydSteinbergDithering) {
        this.thresholdForFloydSteinbergDithering = thresholdForFloydSteinbergDithering;
    }

    @ApiModelProperty(value="Gets or sets the method used while converting images to 1 bpp format.")
    public TiffBinarizationMethodEnum getTiffBinarizationMethod() {
        return this.tiffBinarizationMethod;
    }

    public TiffSaveOptionsData tiffBinarizationMethod(TiffBinarizationMethodEnum tiffBinarizationMethod) {
        this.tiffBinarizationMethod = tiffBinarizationMethod;
        return this;
    }

    public void setTiffBinarizationMethod(TiffBinarizationMethodEnum tiffBinarizationMethod) {
        this.tiffBinarizationMethod = tiffBinarizationMethod;
    }

    @ApiModelProperty(value="Gets or sets the type of compression.")
    public TiffCompressionEnum getTiffCompression() {
        return this.tiffCompression;
    }

    public TiffSaveOptionsData tiffCompression(TiffCompressionEnum tiffCompression) {
        this.tiffCompression = tiffCompression;
        return this;
    }

    public void setTiffCompression(TiffCompressionEnum tiffCompression) {
        this.tiffCompression = tiffCompression;
    }

    public TiffSaveOptionsData() {
        this.saveFormat = "tiff";
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TiffSaveOptionsData tiffSaveOptionsData = (TiffSaveOptionsData)o;
        return Objects.equals(this.thresholdForFloydSteinbergDithering, tiffSaveOptionsData.thresholdForFloydSteinbergDithering) && Objects.equals((Object)this.tiffBinarizationMethod, (Object)tiffSaveOptionsData.tiffBinarizationMethod) && Objects.equals((Object)this.tiffCompression, (Object)tiffSaveOptionsData.tiffCompression) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.thresholdForFloydSteinbergDithering, this.tiffBinarizationMethod, this.tiffCompression, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TiffSaveOptionsData {\n");
        sb.append("    allowEmbeddingPostScriptFonts: ").append(this.toIndentedString(this.getAllowEmbeddingPostScriptFonts())).append("\n");
        sb.append("    customTimeZoneInfoData: ").append(this.toIndentedString(this.getCustomTimeZoneInfoData())).append("\n");
        sb.append("    dml3DEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDml3DEffectsRenderingMode())).append("\n");
        sb.append("    dmlEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDmlEffectsRenderingMode())).append("\n");
        sb.append("    dmlRenderingMode: ").append(this.toIndentedString((Object)this.getDmlRenderingMode())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    imlRenderingMode: ").append(this.toIndentedString((Object)this.getImlRenderingMode())).append("\n");
        sb.append("    updateAmbiguousTextFont: ").append(this.toIndentedString(this.getUpdateAmbiguousTextFont())).append("\n");
        sb.append("    updateCreatedTimeProperty: ").append(this.toIndentedString(this.getUpdateCreatedTimeProperty())).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.getUpdateFields())).append("\n");
        sb.append("    updateLastPrintedProperty: ").append(this.toIndentedString(this.getUpdateLastPrintedProperty())).append("\n");
        sb.append("    updateLastSavedTimeProperty: ").append(this.toIndentedString(this.getUpdateLastSavedTimeProperty())).append("\n");
        sb.append("    zipOutput: ").append(this.toIndentedString(this.getZipOutput())).append("\n");
        sb.append("    colorMode: ").append(this.toIndentedString((Object)this.getColorMode())).append("\n");
        sb.append("    jpegQuality: ").append(this.toIndentedString(this.getJpegQuality())).append("\n");
        sb.append("    metafileRenderingOptions: ").append(this.toIndentedString(this.getMetafileRenderingOptions())).append("\n");
        sb.append("    numeralFormat: ").append(this.toIndentedString((Object)this.getNumeralFormat())).append("\n");
        sb.append("    optimizeOutput: ").append(this.toIndentedString(this.getOptimizeOutput())).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.getPageCount())).append("\n");
        sb.append("    pageIndex: ").append(this.toIndentedString(this.getPageIndex())).append("\n");
        sb.append("    horizontalResolution: ").append(this.toIndentedString(this.getHorizontalResolution())).append("\n");
        sb.append("    imageBrightness: ").append(this.toIndentedString(this.getImageBrightness())).append("\n");
        sb.append("    imageColorMode: ").append(this.toIndentedString((Object)this.getImageColorMode())).append("\n");
        sb.append("    imageContrast: ").append(this.toIndentedString(this.getImageContrast())).append("\n");
        sb.append("    paperColor: ").append(this.toIndentedString(this.getPaperColor())).append("\n");
        sb.append("    pixelFormat: ").append(this.toIndentedString((Object)this.getPixelFormat())).append("\n");
        sb.append("    resolution: ").append(this.toIndentedString(this.getResolution())).append("\n");
        sb.append("    scale: ").append(this.toIndentedString(this.getScale())).append("\n");
        sb.append("    useAntiAliasing: ").append(this.toIndentedString(this.getUseAntiAliasing())).append("\n");
        sb.append("    useHighQualityRendering: ").append(this.toIndentedString(this.getUseHighQualityRendering())).append("\n");
        sb.append("    verticalResolution: ").append(this.toIndentedString(this.getVerticalResolution())).append("\n");
        sb.append("    imageHeight: ").append(this.toIndentedString(this.getImageHeight())).append("\n");
        sb.append("    imageWidth: ").append(this.toIndentedString(this.getImageWidth())).append("\n");
        sb.append("    useGdiEmfRenderer: ").append(this.toIndentedString(this.getUseGdiEmfRenderer())).append("\n");
        sb.append("    thresholdForFloydSteinbergDithering: ").append(this.toIndentedString(this.getThresholdForFloydSteinbergDithering())).append("\n");
        sb.append("    tiffBinarizationMethod: ").append(this.toIndentedString((Object)this.getTiffBinarizationMethod())).append("\n");
        sb.append("    tiffCompression: ").append(this.toIndentedString((Object)this.getTiffCompression())).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.getSaveFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TiffBinarizationMethodEnum {
        THRESHOLD("Threshold"),
        FLOYDSTEINBERGDITHERING("FloydSteinbergDithering");

        private String value;

        private TiffBinarizationMethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TiffBinarizationMethodEnum fromValue(String text) {
            for (TiffBinarizationMethodEnum b : TiffBinarizationMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TiffBinarizationMethodEnum> {
            public void write(JsonWriter jsonWriter, TiffBinarizationMethodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TiffBinarizationMethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TiffBinarizationMethodEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TiffCompressionEnum {
        NONE("None"),
        RLE("Rle"),
        LZW("Lzw"),
        CCITT3("Ccitt3"),
        CCITT4("Ccitt4");

        private String value;

        private TiffCompressionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TiffCompressionEnum fromValue(String text) {
            for (TiffCompressionEnum b : TiffCompressionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TiffCompressionEnum> {
            public void write(JsonWriter jsonWriter, TiffCompressionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TiffCompressionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TiffCompressionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

