/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.FixedPageSaveOptionsData;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for xaml fixed save options.")
public class XamlFixedSaveOptionsData
extends FixedPageSaveOptionsData {
    @SerializedName(value="ResourcesFolder")
    protected String resourcesFolder = null;
    @SerializedName(value="ResourcesFolderAlias")
    protected String resourcesFolderAlias = null;

    @ApiModelProperty(value="Gets or sets the physical folder where resources (images and fonts) are saved when exporting a document to fixed page Xaml format. The default value is null. When you save a Document in fixed page Xaml format, Aspose.Words needs to save all images embedded in the document as standalone files. ResourcesFolder allows you to specify where the images will be saved and ResourcesFolderAlias allows to specify how the image URIs will be constructed.If you save a document into a file and provide a file name, Aspose.Words, by default, saves the images in the same folder where the document file is saved. Use ResourcesFolder to override this behavior.If you save a document into a stream, Aspose.Words does not have a folder where to save the images, but still needs to save the images somewhere. In this case, you need to specify an accessible folder by using the ResourcesFolder property.")
    public String getResourcesFolder() {
        return this.resourcesFolder;
    }

    public XamlFixedSaveOptionsData resourcesFolder(String resourcesFolder) {
        this.resourcesFolder = resourcesFolder;
        return this;
    }

    public void setResourcesFolder(String resourcesFolder) {
        this.resourcesFolder = resourcesFolder;
    }

    @ApiModelProperty(value="Gets or sets the name of the folder used to construct image URIs written into an fixed page Xaml document. The default value is null. When you save a Document in fixed page Xaml format, Aspose.Words needs to save all images embedded in the document as standalone files. ResourcesFolder allows you to specify where the images will be saved and ResourcesFolderAlias allows to specify how the image URIs will be constructed.")
    public String getResourcesFolderAlias() {
        return this.resourcesFolderAlias;
    }

    public XamlFixedSaveOptionsData resourcesFolderAlias(String resourcesFolderAlias) {
        this.resourcesFolderAlias = resourcesFolderAlias;
        return this;
    }

    public void setResourcesFolderAlias(String resourcesFolderAlias) {
        this.resourcesFolderAlias = resourcesFolderAlias;
    }

    public XamlFixedSaveOptionsData() {
        this.saveFormat = "xamlfixed";
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XamlFixedSaveOptionsData xamlFixedSaveOptionsData = (XamlFixedSaveOptionsData)o;
        return Objects.equals(this.resourcesFolder, xamlFixedSaveOptionsData.resourcesFolder) && Objects.equals(this.resourcesFolderAlias, xamlFixedSaveOptionsData.resourcesFolderAlias) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.resourcesFolder, this.resourcesFolderAlias, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class XamlFixedSaveOptionsData {\n");
        sb.append("    allowEmbeddingPostScriptFonts: ").append(this.toIndentedString(this.getAllowEmbeddingPostScriptFonts())).append("\n");
        sb.append("    customTimeZoneInfoData: ").append(this.toIndentedString(this.getCustomTimeZoneInfoData())).append("\n");
        sb.append("    dml3DEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDml3DEffectsRenderingMode())).append("\n");
        sb.append("    dmlEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDmlEffectsRenderingMode())).append("\n");
        sb.append("    dmlRenderingMode: ").append(this.toIndentedString((Object)this.getDmlRenderingMode())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    imlRenderingMode: ").append(this.toIndentedString((Object)this.getImlRenderingMode())).append("\n");
        sb.append("    updateAmbiguousTextFont: ").append(this.toIndentedString(this.getUpdateAmbiguousTextFont())).append("\n");
        sb.append("    updateCreatedTimeProperty: ").append(this.toIndentedString(this.getUpdateCreatedTimeProperty())).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.getUpdateFields())).append("\n");
        sb.append("    updateLastPrintedProperty: ").append(this.toIndentedString(this.getUpdateLastPrintedProperty())).append("\n");
        sb.append("    updateLastSavedTimeProperty: ").append(this.toIndentedString(this.getUpdateLastSavedTimeProperty())).append("\n");
        sb.append("    zipOutput: ").append(this.toIndentedString(this.getZipOutput())).append("\n");
        sb.append("    colorMode: ").append(this.toIndentedString((Object)this.getColorMode())).append("\n");
        sb.append("    jpegQuality: ").append(this.toIndentedString(this.getJpegQuality())).append("\n");
        sb.append("    metafileRenderingOptions: ").append(this.toIndentedString(this.getMetafileRenderingOptions())).append("\n");
        sb.append("    numeralFormat: ").append(this.toIndentedString((Object)this.getNumeralFormat())).append("\n");
        sb.append("    optimizeOutput: ").append(this.toIndentedString(this.getOptimizeOutput())).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.getPageCount())).append("\n");
        sb.append("    pageIndex: ").append(this.toIndentedString(this.getPageIndex())).append("\n");
        sb.append("    resourcesFolder: ").append(this.toIndentedString(this.getResourcesFolder())).append("\n");
        sb.append("    resourcesFolderAlias: ").append(this.toIndentedString(this.getResourcesFolderAlias())).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.getSaveFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

