/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.SaveOptionsData;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for xaml flow save options.")
public class XamlFlowSaveOptionsData
extends SaveOptionsData {
    @SerializedName(value="ImagesFolder")
    protected String imagesFolder = null;
    @SerializedName(value="ImagesFolderAlias")
    protected String imagesFolderAlias = null;
    @SerializedName(value="ReplaceBackslashWithYenSign")
    protected Boolean replaceBackslashWithYenSign = null;

    @ApiModelProperty(value="Gets or sets the physical folder where images are saved when exporting.")
    public String getImagesFolder() {
        return this.imagesFolder;
    }

    public XamlFlowSaveOptionsData imagesFolder(String imagesFolder) {
        this.imagesFolder = imagesFolder;
        return this;
    }

    public void setImagesFolder(String imagesFolder) {
        this.imagesFolder = imagesFolder;
    }

    @ApiModelProperty(value="Gets or sets the name of the folder used to construct image URIs.")
    public String getImagesFolderAlias() {
        return this.imagesFolderAlias;
    }

    public XamlFlowSaveOptionsData imagesFolderAlias(String imagesFolderAlias) {
        this.imagesFolderAlias = imagesFolderAlias;
        return this;
    }

    public void setImagesFolderAlias(String imagesFolderAlias) {
        this.imagesFolderAlias = imagesFolderAlias;
    }

    @ApiModelProperty(value="Gets or sets the flag that indicates whether backslash characters should be replaced with yen signs. The default value is false. By default, Aspose.Words mimics MS Word's behavior and doesn't replace backslash characters with yen signs in generated HTML documents. However, previous versions of Aspose.Words performed such replacements in certain scenarios. This flag enables backward compatibility with previous versions of Aspose.Words.")
    public Boolean getReplaceBackslashWithYenSign() {
        return this.replaceBackslashWithYenSign;
    }

    public XamlFlowSaveOptionsData replaceBackslashWithYenSign(Boolean replaceBackslashWithYenSign) {
        this.replaceBackslashWithYenSign = replaceBackslashWithYenSign;
        return this;
    }

    public void setReplaceBackslashWithYenSign(Boolean replaceBackslashWithYenSign) {
        this.replaceBackslashWithYenSign = replaceBackslashWithYenSign;
    }

    public XamlFlowSaveOptionsData() {
        this.saveFormat = "xamlflow";
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XamlFlowSaveOptionsData xamlFlowSaveOptionsData = (XamlFlowSaveOptionsData)o;
        return Objects.equals(this.imagesFolder, xamlFlowSaveOptionsData.imagesFolder) && Objects.equals(this.imagesFolderAlias, xamlFlowSaveOptionsData.imagesFolderAlias) && Objects.equals(this.replaceBackslashWithYenSign, xamlFlowSaveOptionsData.replaceBackslashWithYenSign) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.imagesFolder, this.imagesFolderAlias, this.replaceBackslashWithYenSign, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class XamlFlowSaveOptionsData {\n");
        sb.append("    allowEmbeddingPostScriptFonts: ").append(this.toIndentedString(this.getAllowEmbeddingPostScriptFonts())).append("\n");
        sb.append("    customTimeZoneInfoData: ").append(this.toIndentedString(this.getCustomTimeZoneInfoData())).append("\n");
        sb.append("    dml3DEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDml3DEffectsRenderingMode())).append("\n");
        sb.append("    dmlEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDmlEffectsRenderingMode())).append("\n");
        sb.append("    dmlRenderingMode: ").append(this.toIndentedString((Object)this.getDmlRenderingMode())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    imlRenderingMode: ").append(this.toIndentedString((Object)this.getImlRenderingMode())).append("\n");
        sb.append("    updateAmbiguousTextFont: ").append(this.toIndentedString(this.getUpdateAmbiguousTextFont())).append("\n");
        sb.append("    updateCreatedTimeProperty: ").append(this.toIndentedString(this.getUpdateCreatedTimeProperty())).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.getUpdateFields())).append("\n");
        sb.append("    updateLastPrintedProperty: ").append(this.toIndentedString(this.getUpdateLastPrintedProperty())).append("\n");
        sb.append("    updateLastSavedTimeProperty: ").append(this.toIndentedString(this.getUpdateLastSavedTimeProperty())).append("\n");
        sb.append("    zipOutput: ").append(this.toIndentedString(this.getZipOutput())).append("\n");
        sb.append("    imagesFolder: ").append(this.toIndentedString(this.getImagesFolder())).append("\n");
        sb.append("    imagesFolderAlias: ").append(this.toIndentedString(this.getImagesFolderAlias())).append("\n");
        sb.append("    replaceBackslashWithYenSign: ").append(this.toIndentedString(this.getReplaceBackslashWithYenSign())).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.getSaveFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

