/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model.requests;

import com.aspose.words.cloud.ApiClient;
import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.Pair;
import com.aspose.words.cloud.ProgressRequestBody;
import com.aspose.words.cloud.ProgressResponseBody;
import com.aspose.words.cloud.model.DocumentResponse;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.RangeDocument;
import com.aspose.words.cloud.model.requests.RequestIfc;
import com.aspose.words.cloud.model.responses.SaveAsRangeOnlineResponse;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMultipart;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class SaveAsRangeOnlineRequest
implements RequestIfc {
    private byte[] document;
    private String rangeStartIdentifier;
    private RangeDocument documentParameters;
    private String rangeEndIdentifier;
    private String loadEncoding;
    private String password;
    private String encryptedPassword;
    private Boolean openTypeSupport;

    public SaveAsRangeOnlineRequest(byte[] document, String rangeStartIdentifier, RangeDocument documentParameters, String rangeEndIdentifier, String loadEncoding, String password, String encryptedPassword, Boolean openTypeSupport) {
        this.document = document;
        this.rangeStartIdentifier = rangeStartIdentifier;
        this.documentParameters = documentParameters;
        this.rangeEndIdentifier = rangeEndIdentifier;
        this.loadEncoding = loadEncoding;
        this.password = password;
        this.encryptedPassword = encryptedPassword;
        this.openTypeSupport = openTypeSupport;
    }

    public byte[] getDocument() {
        return this.document;
    }

    public void setDocument(byte[] value) {
        this.document = value;
    }

    public String getRangeStartIdentifier() {
        return this.rangeStartIdentifier;
    }

    public void setRangeStartIdentifier(String value) {
        this.rangeStartIdentifier = value;
    }

    public RangeDocument getDocumentParameters() {
        return this.documentParameters;
    }

    public void setDocumentParameters(RangeDocument value) {
        this.documentParameters = value;
    }

    public String getRangeEndIdentifier() {
        return this.rangeEndIdentifier;
    }

    public void setRangeEndIdentifier(String value) {
        this.rangeEndIdentifier = value;
    }

    public String getLoadEncoding() {
        return this.loadEncoding;
    }

    public void setLoadEncoding(String value) {
        this.loadEncoding = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String value) {
        this.encryptedPassword = value;
    }

    public Boolean getOpenTypeSupport() {
        return this.openTypeSupport;
    }

    public void setOpenTypeSupport(Boolean value) {
        this.openTypeSupport = value;
    }

    @Override
    public Request buildHttpRequest(ApiClient apiClient, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, Boolean addAuthHeaders) throws ApiException, IOException {
        if (this.getDocument() == null) {
            throw new ApiException(apiClient.getBadRequestCode(), "Missing the required parameter 'Document' when calling saveAsRangeOnline");
        }
        if (this.getRangeStartIdentifier() == null) {
            throw new ApiException(apiClient.getBadRequestCode(), "Missing the required parameter 'RangeStartIdentifier' when calling saveAsRangeOnline");
        }
        if (this.getDocumentParameters() == null) {
            throw new ApiException(apiClient.getBadRequestCode(), "Missing the required parameter 'DocumentParameters' when calling saveAsRangeOnline");
        }
        if (this.getDocumentParameters() != null) {
            this.getDocumentParameters().validate();
        }
        String localVarPath = "/words/online/post/range/{rangeStartIdentifier}/{rangeEndIdentifier}/SaveAs";
        localVarPath = apiClient.addParameterToPath(localVarPath, "rangeStartIdentifier", this.getRangeStartIdentifier());
        localVarPath = apiClient.addParameterToPath(localVarPath, "rangeEndIdentifier", this.getRangeEndIdentifier());
        localVarPath = localVarPath.replaceAll("//", "/");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        apiClient.addParameterToQuery(localVarQueryParams, "loadEncoding", this.getLoadEncoding());
        apiClient.addParameterToQuery(localVarQueryParams, "password", this.getPassword());
        apiClient.addParameterToQuery(localVarQueryParams, "encryptedPassword", this.getEncryptedPassword());
        apiClient.addParameterToQuery(localVarQueryParams, "openTypeSupport", this.getOpenTypeSupport());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        ArrayList<FileReference> localFilesContentParams = new ArrayList<FileReference>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        if (this.getDocument() != null) {
            localVarFormParams.put("Document", this.getDocument());
        }
        if (this.getDocumentParameters() != null) {
            localVarFormParams.put("DocumentParameters", this.getDocumentParameters());
        }
        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){
                final /* synthetic */ SaveAsRangeOnlineRequest this$0;
                {
                    this.this$0 = this$0;
                }

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return apiClient.buildRequest(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarHeaderParams, localVarFormParams, localFilesContentParams, addAuthHeaders, progressRequestListener);
    }

    @Override
    public SaveAsRangeOnlineResponse deserializeResponse(ApiClient apiClient, Response response) throws ApiException, MessagingException, IOException {
        MimeMultipart multipart = apiClient.getMultipartFromResponse(response);
        return new SaveAsRangeOnlineResponse((DocumentResponse)apiClient.parseModel(apiClient.findBodyPartInMultipart("Model", multipart), (Type)((Object)DocumentResponse.class)), apiClient.parseFilesCollection(apiClient.findBodyPartInMultipart("Document", multipart)));
    }
}

